# Rule 15–3–4 (Required) Each exception explicitly thrown in the code shall have a handler of a compatible type in all call paths that could lead to that point.

## Amplification
[Implementation 15.3(9), 15.5.1(2)]

## Rationale
If a program throws an unhandled exception, it terminates in an implementation-defined manner. In particular, it is implementation-defined whether the call stack is unwound before termination, so the destructors of any automatic objects may or may not be invoked.
If an exception is thrown as an object of a derived class, a “compatible type” may be either the derived class or any of its bases.
The objective of this rule is that a program should catch all exceptions that it is expected to throw. The objective of Rule 15–3–2 is to ensure that exceptions that were not expected are also caught.

## Example
```c
class A {}; 
class B {}; 
void f ( int32_t i ) throw ( ) 
{ 
 try 
 { 
 if ( i > 10 ) 
 { 
 throw A ( ); // Compliant 
 } 
 else 
 { 
 throw B ( ); // Non-compliant 
 } 
 } 
 catch ( A const & ) 
 { 
 } 
}
```

## See also
Rule 15–3–2, Rule 15–5–3

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
