# Rule 3–1–1 (Required) It shall be possible to include any header file in multiple translation units without violating the One Definition Rule.

## Rationale
Header files should be used to declare objects, functions, inline functions, function templates, typedefs, macros, classes, and class templates and shall not contain or produce definitions of objects or functions (or fragment of functions or objects) that occupy storage.
A header file is considered to be any file that is included via the #include directive, regardless of name or suffix.

## Example
```c
// a.h 
 void f1 ( ); // Compliant 
 void f2 ( ) { } // Non-compliant 
inline void f3 ( ) { } // Compliant 
template <typename T> 
void f4 ( T ) { } // Compliant
int32_t a; // Non-compliant
// a.cpp 
#include "a.h"
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
