# Rule 3–2–3 (Required) A type, object or function that is used in multiple translation units shall be declared in one and only one file.

## Rationale
Having a single declaration of a type, object or function allows the compiler to detect incompatible types for the same entity.
Normally, this will mean declaring an external identifier in a header file that will be included in any file where the identifier is defined or used.

## Example
```c
// header.hpp 
extern int16_t a;
// file1.cpp 
#include "header.hpp"
extern int16_t b;
// file2.cpp 
#include "header.hpp"
extern int32_t b; // Non-compliant - compiler may not detect the error 
int32_t a; // Compliant - compiler will detect the error
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
