# Rule 5–0–12 (Required) signed char and unsigned char type shall only be used for the storage and use of numeric values.

## Amplification
[Implementation 3.9.1(1), 7.1.5.2(1)]

## Rationale
There are three distinct char types, (plain) char, signed char and unsigned char. signed char and unsigned char shall only be used for numeric data and plain char shall only be used for character data. As it is implementation-defined, the signedness of the plain char type should not be assumed.
Note that Rule 3–9–2 also applies, so the uint8_t and int8_t types are covered by this rule.

## Example
```c
 int8_t a = 'a'; // Non-compliant – explicitly signed 
 uint8_t b = '\r'; // Non-compliant – explicitly unsigned 
 int8_t c = 10; // Compliant 
 uint8_t d = 12U; // Compliant 
signed char e = 11; // Compliant with this rule, but breaks Rule 3–9–2
```

## See also
Rule 3–9–2, Rule 5–0–11

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
