# Rule 5–0–7 (Required) There shall be no explicit floating-integral conversions of a cvalue expression.

## Rationale
A cast applied to the result of an expression does not change the type in which the expression is evaluated, which may be contrary to developer expectations.

## Example
```c
// Integral to Float 
void f1 ( ) 
{ 
 int16_t s16a; 
 int16_t s16b; 
 int16_t s16c; 
 float32_t f32a;
 // The following performs integer division 
 f32a = static_cast< float32_t > ( s16a / s16b ); // Non-compliant
 // The following also performs integer division 
 s16c = s16a / s16b; 
 f32a = static_cast< float32_t > ( s16c ); // Compliant
 // The following performs floating-point division 
 f32a = static_cast< float32_t > ( s16a ) / s16b; // Compliant 
}
```
In the above example, the expression ( s16a / s16b ) is performed with an underlying type of int16_t rather than float32_t.
```c
// Float to Integral 
void f2 ( ) 
{ 
 float32_t f32a; 
 float32_t f32b; 
 float32_t f32c; 
 int16_t s16a;
 // The following performs floating-point division 
 s16a = static_cast< int16_t > ( f32a / f32b ); // Non-compliant
 // The following also performs floating-point division 
 f32c = f32a / f32b; 
 s16a = static_cast< int16_t > ( f32c ); // Compliant
 // The following performs integer division 
 s16a = static_cast< int16_t > ( f32a ) / f32b; // Compliant 
}
```
In the above example, the expression ( f32a / f32b ) is performed with an underlying type of float32_t rather than int16_t.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
