# Rule 6–5–2 (Required) If loop-counter is not modified by -- or ++, then, within condition, the loop-counter shall only be used as an operand to <=, <, > or >=.

## Rationale
When the loop-counter is modified using an operator other than -- or ++, then == and != shall not be used, as loop termination may not occur, which may be inconsistent with developer expectations.

## Example
```c
for ( i = 1; i != 10; i += 2 ) // Non-compliant 
for ( i = 1; i <= 10; i += 2 ) // Compliant 
for ( i = 1; i != 10; ++i ) // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
