# Rule 7–3–2 (Required) The identifier main shall not be used for a function other than the global function main.

## Amplification
[Implementation 3.6.1(2, 3)]

## Rationale
main (or its equivalent) is usually the entry point to the program and is the only identifier which must be in the global namespace. The use of main for other functions may not meet developer expectations.

## Example
```c
int32_t main ( ) // Compliant 
{ 
}
namespace 
{ 
 int32_t main ( ) // Non-compliant 
 { 
 } 
}
namespace NS 
{ 
 int32_t main ( ) // Non-compliant 
 { 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
