# Rule 8–5–3 (Required) In an enumerator list, the = construct shall not be used to explicitly initialize members other than the first, unless all items are explicitly initialized.

## Rationale
If an enumerator list is given with no explicit initialization of members, then C++ allocates a sequence of integers starting at zero for the first element and increasing by one for each subsequent element.
An explicit initialization of the first element, as permitted by the above rule, forces the allocation of integers to start at the given value. When adopting this approach it is essential to ensure that the initialization value used is small enough that no subsequent value in the list will exceed the int storage used by enumeration constants.
Explicit initialization of all items in the list, which is also permissible, prevents the mixing of automatic and manual allocation, which is error prone. However it is then the responsibility of the developer to ensure that all values are in the required range, and that values are not unintentionally duplicated.

## Example
The following example assigns the same value to the green and yellow enumeration constants. It is unclear to a reviewer if this was intentional or an error.
```c
enum colour { red=3, blue, green, yellow=5 }; // Non-compliant
```
However, if all the items are explicitly initialized, then the duplicated values are acceptable as the duplication is readily detectable by anyone reviewing the code.
```c
enum colour { red=3, blue=4, green=5, yellow=5 }; // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
