# Rule 18.1.2 An empty throw shall only occur within the compound-statement of a catch handler

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
An *empty throw* is a *throw-expression* with no operand.

For the purposes of this rule, the body of a lambda declared within the *compound-statement* of a *catch
handler* is not considered to be part of the *catch handler*.

## Rationale
An *empty throw* re-throws the temporary object that represents an exception. Its use is intended to
enable the handling of an exception to be split across two or more handlers.

Syntactically, there is nothing to prevent an *empty throw* from being used outside a *catch handler*.
However, this would result in *implementation-defined* program termination when there is no exception
object to re-throw.

## Example
```cpp
void f1( void )
{
 try
 {
 throw std::range_error( "range error" );
 }
 catch ( std::exception const & )
 {
 log( "Caught in f1" );
 throw; // Compliant - re-throws an exception object
 }
}

void f2( void )
{
 throw; // Non-compliant - not syntactically within a catch
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
