# Rule 28.6.1 The argument to std::move shall be a non-const lvalue

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
The result of calling `std::move` on an object that is `const` will result in the object's content not
being moved.

Calling `std::move` on an *rvalue* is redundant.

## Example
```cpp
void f1( std::string && ); // #1
void f1( std::string const & ); // #2

void f2( std::string const & s1, std::string s2 )
{
 f1( s1 ); // Calls #2
 f1( std::move( s1 ) ); // Non-compliant - calls #2
 f1( std::move( s2 ) ); // Compliant - calls #1

 f1( std::string( "abc" ) ); // Calls #1
 f1( std::move( std::string( "abc" ) ) ); // Non-compliant - redundant move of
} // temporary, also calls #1
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
