Disallows usage of the `host` metadata property. See more at https://angular.io/styleguide#style-06-03

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  host: {
  ~~~~~~~
    class: 'my-class',
    [type]: 'test',
    '(click)': 'bar()'
  },
  ~
  selector: 'app-test'
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  host: {
  ~~~~~~~
    class: 'my-class',
    [type]: 'test',
    '(click)': 'bar()'
  },
  ~
  selector: 'app-test'
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const computed = '[class]';

@Directive({
  host: {
    [computed]: 'test',
    ~~~~~~~~~~~~~~~~~~
    static: true,
    'class': 'class1',
    '(click)': 'bar()',
    ~~~~~~~~~~~~~~~~~~
    '[attr.role]': role,
    ~~~~~~~~~~~~~~~~~~~
    '[@routerTransition]': 'test'
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  },
  selector: 'app-test'
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  host,
  ~~~~
  selector: 'app-test'
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'app-test',
  template: 'Hello'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'app-test'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const shorthand = 'testing';

@Component({
  host: {
    shorthand,
    static: true,
    'class': 'class1',
    '[@routerTransition]': ''
  },
  selector: 'app-test'
})
class Test {}
```

</details>
