Ensures that output bindings, including aliases, are not named "on", nor prefixed with it. See more at https://angular.io/guide/styleguide#style-05-16

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  outputs: ['on']
            ~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  inputs: [onCredit],
  'outputs': [onLevel, `test: on`, onFunction()],
                       ~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  ['outputs']: ['onTest: test', ...onArray],
                ~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  [`outputs`]: ['onTest: test', ...onArray],
                ~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Output() on: EventEmitter<any> = new EventEmitter<{}>();
            ~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  @Output() @Custom('on') 'onPrefix' = new EventEmitter<void>();
                          ~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Custom() @Output(`on`) _on = getOutput();
                    ~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  @Output('onPrefix') _on = (this.subject$ as Subject<{on: boolean}>).pipe();
          ~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Output('getter') get 'on-getter'() {}
                        ~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  @Output('on') onPrefix = this.getOutput();
          ~~~~  ~~~~~~~~
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Page({
  outputs: ['on', onChange, `onLine`, 'on: on2', 'offline: on', ...onCheck, onOutput()],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  on = new EventEmitter();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  @Output() buttonChange = new EventEmitter<'on'>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  @Output() On = new EventEmitter<{ on: onType }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  @Output(`one`) ontype = new EventEmitter<{ bar: string, on: boolean }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  @Output('oneProp') common = new EventEmitter<ComplextOn>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test<On> {
  @Output() ON = new EventEmitter<On>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const on = 'on';
@Component()
class Test {
  @Output(on) touchMove: EventEmitter<{ action: 'on' | 'off' }> = new EventEmitter<{ action: 'on' | 'off' }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const test = 'on';
const on = 'on';
@Directive()
class Test {
  @Output(test) [on]: EventEmitter<OnTest>;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'foo',
})
class Test {
  @Output() get 'getter'() {}
}
```

</details>
