Checks cyclomatic complexity against a specified limit. It is a quantitative measure of the number of linearly independent paths through a program's source code

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<div *ngIf="a === '1'">
  <div *ngFor="let person of persons; trackBy: trackByFn">
    <div *ngIf="a === '1'">{{ person.name }}</div>
    <div [ngSwitch]="person.emotion">
      <app-happy-hero    *ngSwitchCase="'happy'"    [hero]="currentHero"></app-happy-hero>
      <app-sad-hero      *ngSwitchCase="'sad'"      [hero]="currentHero"></app-sad-hero>
      <app-confused-hero *ngSwitchCase="'confused'" [hero]="currentHero"></app-confused-hero>
                          ~~~~~~~~~~~~~~~~~~~~~~~~
      <app-unknown-hero  *ngSwitchDefault           [hero]="currentHero"></app-unknown-hero>
                          ~~~~~~~~~~~~~~~
    </div>
  </div>
</div>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [fakeDirective]="'test'"></div>
<ng-template ngFor let-person [ngForOf]="persons" let-i="index">
  {{ person.name }}
</ng-template>
<ng-template [ngIf]="a === '1'">
  something here
</ng-template>
<div *ngIf="a === '1'">
  <div *ngFor="let person of persons; trackBy: trackByFn">
    <div *ngIf="a === '1'">{{ person.name }}</div>
    <div [ngSwitch]="person.emotion">
      <app-happy-hero    *ngSwitchCase="'happy'"    [hero]="currentHero"></app-happy-hero>
      <app-sad-hero      *ngSwitchCase="'sad'"      [hero]="currentHero"></app-sad-hero>
                          ~~~~~~~~~~~~~~~~~~~
      <app-confused-hero *ngSwitchCase="'confused'" [hero]="currentHero"></app-confused-hero>
                          ~~~~~~~~~~~~~~~~~~~~~~~~
      <app-unknown-hero  *ngSwitchDefault           [hero]="currentHero"></app-unknown-hero>
                          ~~~~~~~~~~~~~~~
    </div>
  </div>
</div>
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<div *ngIf="a === '1'">
  <div>{{ person.name }}</div>
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngIf="a === '1'">
  <div *ngFor="let person of persons; trackBy: trackByFn">
    {{ person.name }}
  </div>
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngIf="a === '1'">
  <div *ngFor="let person of persons; trackBy: trackByFn">
    {{ person.name }}
    <div [ngSwitch]="person.emotion">
      <app-happy-hero    *ngSwitchCase="'happy'" [hero]="currentHero"></app-happy-hero>
      <app-sad-hero      *ngSwitchCase="'sad'"   [hero]="currentHero"></app-sad-hero>
      <app-unknown-hero  *ngSwitchDefault        [hero]="currentHero"></app-unknown-hero>
    </div>
  </div>
</div>
```

</details>
