Using the `providedIn` property makes `Injectables` tree-shakable

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Injectable()
~~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({})
~~~~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const providedIn = 'anotherProperty';
@Injectable({ [providedIn]: [] })
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({ providedIn: null })
                          ~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({ ['providedIn']: undefined })
                              ~~~~~~~~~
class Test {}

@Injectable()
class HttpPostInterceptor implements HttpInterceptor {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({ ['providedIn']: undefined })
                              ~~~~~~~~~
class Test {}

@Injectable()
class ProvidedInNgModule {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({ [`providedIn`]: undefined })
                              ~~~~~~~~~
class Test {}

@Injectable()
class TestEffects {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const options = {};
@Injectable(options)
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  providedIn: `any`,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  'providedIn': 'root',
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  ['providedIn']: SomeModule,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  [`providedIn`]: providedIn(),
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable()
class Test implements HttpInterceptor {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable()
class Test implements ng.HttpInterceptor {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable()
class TestEffects {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@CustomInjectable()
class Test {}
```

</details>
