Enforce propTypes declarations alphabetical sorting.




🔧 This rule is automatically fixable using the `--fix` [flag](https://eslint.org/docs/latest/user-guide/command-line-interface#--fix) on the command line.

Some developers prefer to sort prop type declarations alphabetically to be able to find necessary declaration easier at the later time. Others feel that it adds complexity and becomes burden to maintain.

## Rule Details

This rule checks all components and verifies that all propTypes declarations are sorted alphabetically. A spread attribute resets the verification. The default configuration of the rule is case-sensitive.

Examples of **incorrect** code for this rule:

```jsx
var Component = createReactClass({
  propTypes: {
    z: PropTypes.number,
    a: PropTypes.any,
    b: PropTypes.string
  },
...
});
```

```jsx
type Props = {
  z: number,
  a: any,
  b: string
}
class Component extends React.Component<Props> {
  ...
}
```

```jsx
class Component extends React.Component {
  static propTypes = {
    z: PropTypes.any,
    y: PropTypes.any,
    a: PropTypes.any
  }
  render() {
    return <div />;
  }
}
```

Examples of **correct** code for this rule:

```jsx
var Component = createReactClass({
  propTypes: {
    a: PropTypes.number,
    b: PropTypes.any,
    c: PropTypes.string
  },
...
});
```

```jsx
type Props = {
  a: string,
  b: any,
  c: string,
}
class Component extends React.Component<Props> {
  ...
}
```

```jsx
class Component extends React.Component {
  static propTypes = {
    a: PropTypes.any,
    b: PropTypes.any,
    c: PropTypes.any
  }
  render() {
    return <div />;
  }
}
```

## When Not To Use It

This rule is a formatting preference and not following it won't negatively affect the quality of your code. If alphabetizing props declarations isn't a part of your coding standards, then you can leave this rule off.
