<h2>Why is this an issue?</h2>
<p>The difference between <code>private</code> and <code>protected</code> visibility is that child classes can see and use <code>protected</code>
members, but they cannot see <code>private</code> ones. Since a <code>sealed</code> class cannot have children, marking its members
<code>protected</code> is confusingly pointless.</p>
<h3>Noncompliant code example</h3>
<pre>
public sealed class MySealedClass
{
    protected string name = "Fred";  // Noncompliant
    protected void SetName(string name) // Noncompliant
    {
        // ...
    }
}
</pre>
<h3>Compliant solution</h3>
<pre>
public sealed class MySealedClass
{
    private string name = "Fred";
    public void SetName(string name)
    {
        // ...
    }
}
</pre>

