<h2>Why is this an issue?</h2>
<p>The compiler automatically initializes class fields, auto-properties and events to their default values before setting them with any initialization
values, so there is no need to explicitly set a member to its default value. Further, under the logic that cleaner code is better code, it’s
considered poor style to do so.</p>
<h3>Noncompliant code example</h3>
<pre>
class X
{
  public int field = 0; // Noncompliant
  public object o = null; // Noncompliant
  public object MyProperty { get; set; } = null; // Noncompliant
  public event EventHandler MyEvent = null;  // Noncompliant
}
</pre>
<h3>Compliant solution</h3>
<pre>
class X
{
  public int field;
  public object o;
  public object MyProperty { get; set; }
  public event EventHandler MyEvent;
}
</pre>
<h3>Exceptions</h3>
<p><code>const</code> fields are ignored.</p>

