<h2>Why is this an issue?</h2>
<p>There’s no point in creating an array solely for the purpose of passing it to a <code>params</code> parameter. Simply pass the elements directly.
They will be consolidated into an array automatically.</p>
<h3>Noncompliant code example</h3>
<pre>
public void Base()
{
    Method(new string[] { "s1", "s2" }); // Noncompliant: unnecessary
    Method(new string[] { });            // Noncompliant
    Method(new string[12]);              // Compliant
}

public void Method(params string[] args)
{
    // ...
}
</pre>
<h3>Compliant solution</h3>
<pre>
public void Base()
{
    Method("s1", "s2");
    Method();
    Method(new string[12]);
}

public void Method(params string[] args)
{
    // ...
}
</pre>

