<h2>Why is this an issue?</h2>
<p>When the line immediately after conditional statements has neither curly braces nor indentation, the intent of the code is unclear and perhaps not
executed as expected. Additionally, such code is confusing to maintainers.</p>
<p>The rule will check the line indentation after the following conditional statements:</p>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/selection-statements#the-if-statement">if and if-else
  statements</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-for-statement">for
  statement</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-foreach-statement">foreach
  statement</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-do-statement">do statement</a>
  </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-while-statement">while
  statement</a> </li>
</ul>
<pre>
if (condition)  // Noncompliant
DoTheThing();
DoTheOtherThing(); // Was the intent to call this function unconditionally?
</pre>
<p>It becomes even more confusing and bug-prone if lines get commented out.</p>
<pre>
if (condition)  // Noncompliant
//   DoTheThing();
DoTheOtherThing(); // Was the intent to call this function conditionally?
</pre>
<p>Indentation alone or together with curly braces makes the intent clear.</p>
<pre>
if (condition)
  DoTheThing();
DoTheOtherThing(); // Clear intent to call this function unconditionally

// or

if (condition)
{
  DoTheThing();
}
DoTheOtherThing(); // Clear intent to call this function unconditionally
</pre>

