﻿## SA1022

<table>
<tr>
  <td>TypeName</td>
  <td>SA1022PositiveSignsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1022</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A positive sign within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around a positive sign is not correct.

A positive sign should always be preceded by a single space, unless it comes after an opening square bracket, a parenthesis, a brace of an interpolated string, is the first character on the line, or is part of a string interpolation alignment component.

A positive sign should never be followed by whitespace, and should never be the last character on a line.

## How to fix violations

To fix a violation of this rule, ensure that the spacing around the positive sign follows the rule described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1022:PositiveSignsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1022 // PositiveSignsMustBeSpacedCorrectly
#pragma warning restore SA1022 // PositiveSignsMustBeSpacedCorrectly
```
