## SA1316

<table>
<tr>
  <td>TypeName</td>
  <td>SA1316TupleElementNamesShouldUseCorrectCasing</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1316</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.
:memo: This rule is only active for C# 7.0 and higher

## Cause

Element names within a tuple type should have the correct casing.

## Rule description

Tuple types with element names should use the configured casing for the element names (see [Configuration.md](Configuration.md) for details).  See the documentation on [tuple types](https://docs.microsoft.com/en-us/dotnet/csharp/tuples) for information on how to work with tuples in C# 7.

For example, the following code would produce a violation of this rule (with default settings):

```csharp
public class ExampleClass
{
  public (int valueA, int valueB) ExampleMethod() // SA1316
  {
  }
}
```

The following code would not produce any violations:

```csharp
public class ExampleClass
{
  public (int ValueA, int ValueB) ExampleMethod()
  {
  }
}
```

## How to fix violations

To fix a violation of this rule, correct the casing of the tuple element name.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.NamingRules", "SA1316:TupleElementNamesShouldUseCorrectCasing", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1316 // Tuple element names should use correct casing
#pragma warning restore SA1316 // Tuple element names should use correct casing
```
