﻿## SA1504

<table>
<tr>
  <td>TypeName</td>
  <td>SA1504AllAccessorsMustBeSingleLineOrMultiLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1504</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

Within a C# property, indexer or event, at least one of the child accessors is written on a single line, and at least one of the child accessors is written across multiple lines.

## Rule description

A violation of this rule occurs when the accessors within a property, indexer or event are not consistently written on a single line or on multiple lines. This rule is intended to increase the readability of the code by requiring all of the accessors within an element to be formatted in the same way.

For example, the following property would generate a violation of this rule, because one accessor is written on a single line while the other accessor snaps multiple lines.

```csharp
public bool Enabled
{
    get { return this.enabled; }

    set
    {
        this.enabled = value;
    }
}
```

The violation can be avoided by placing both accessors on a single line, or expanding both accessors across multiple lines:

```csharp
public bool Enabled
{
    get { return this.enabled; }
    set { this.enabled = value; }
}


public bool Enabled
{
    get 
    { 
        return this.enabled; 
    }

    set 
    { 
        this.enabled = value;
    }
}
```

## How to fix violations

To fix a violation of this rule, write each accessor on a single line if the accessors are short, or expand both accessors across multiple lines if the accessors are longer.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1504:AllAccessorsMustBeSingleLineOrMultiLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1504 // AllAccessorsMustBeSingleLineOrMultiLine
#pragma warning restore SA1504 // AllAccessorsMustBeSingleLineOrMultiLine
```
