<p>This rule raises an issue when a private method is never referenced in the code.</p>
<h2>Why is this an issue?</h2>
<p>A method that is never called is dead code, and should be removed. Cleaning out dead code decreases the size of the maintained codebase, making it
easier to understand the program and preventing bugs from being introduced.</p>
<p>This rule detects methods that are never referenced from inside a translation unit, and cannot be referenced from the outside.</p>
<h3>Code examples</h3>
<h3>Noncompliant code example</h3>

```java
public class Foo implements Serializable
{
  public static void doSomething() {
    Foo foo = new Foo();
    ...
  }

  private void unusedPrivateMethod() {...}
  private void writeObject(ObjectOutputStream s) {...}  //Compliant, relates to the java serialization mechanism
  private void readObject(ObjectInputStream in) {...}  //Compliant, relates to the java serialization mechanism
}
```
<h3>Compliant solution</h3>

```java
public class Foo implements Serializable
{
  public static void doSomething(){
    Foo foo = new Foo();
    ...
  }

  private void writeObject(ObjectOutputStream s) {...}  //Compliant, relates to the java serialization mechanism
  private void readObject(ObjectInputStream in) {...}  //Compliant, relates to the java serialization mechanism
}
```
<h3>Exceptions</h3>
<p>This rule doesn’t raise issues for:</p>
<ul>
  <li> annotated methods </li>
  <li> methods with parameters that are annotated with <code>@javax.enterprise.event.Observes</code> </li>
</ul>
<p>The rule does not take reflection into account, which means that issues will be raised on <code>private</code> methods that are only accessed using
the reflection API.</p>