<h2>Why is this an issue?</h2>
<p>According to the Java Language Specification, there is a contract between <code>equals(Object)</code> and <code>hashCode()</code>:</p>
<blockquote>
  <p>If two objects are equal according to the <code>equals(Object)</code> method, then calling the <code>hashCode</code> method on each of the two
  objects must produce the same integer result.</p>
  <p>It is not required that if two objects are unequal according to the <code>equals(java.lang.Object)</code> method, then calling the
  <code>hashCode</code> method on each of the two objects must produce distinct integer results.</p>
  <p>However, the programmer should be aware that producing distinct integer results for unequal objects may improve the performance of
  hashtables.</p>
</blockquote>
<p>In order to comply with this contract, those methods should be either both inherited, or both overridden.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
class MyClass {    // Noncompliant - should also override "hashCode()"

  @Override
  public boolean equals(Object obj) {
    /* ... */
  }

}
```
<h4>Compliant solution</h4>

```java
class MyClass {    // Compliant

  @Override
  public boolean equals(Object obj) {
    /* ... */
  }

  @Override
  public int hashCode() {
    /* ... */
  }

}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/581">CWE-581 - Object Model Violation: Just One of Equals and Hashcode Defined</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/7DVGBQ">CERT, MET09-J.</a> - Classes that define an equals() method must also define a
  hashCode() method </li>
</ul>