<h2>Why is this an issue?</h2>
<p>A <a href="https://docs.oracle.com/javase/tutorial/java/nutsandbolts/for.html"><code>for</code></a> loop is a fundamental programming construct
used to execute a block of code repeatedly. However, if the loop’s condition is false before the first iteration, the loop will never execute.</p>

```java
for (int i = 0; i < 0; i++) {  // Noncompliant: the condition is always false, and the loop will never execute
    // ...
}
```
<p>Rewrite the loop to ensure the condition evaluates to <code>true</code> at least once.</p>

```java
for (int i = 0; i < 10; i++) {  // Compliant: the condition is true at least once, the loop will execute
    // ...
}
```
<p>This bug has the potential to cause unexpected outcomes as the loop might contain critical code that needs to be executed.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Java Documentation - <a href="https://docs.oracle.com/javase/tutorial/java/nutsandbolts/for.html">The <code>for</code> statement</a> </li>
</ul>