<h2>Why is this an issue?</h2>
<p>In JavaScript, many array methods take a callback function as an argument. These methods are designed to transform or filter arrays based on the
logic provided in the callback function. The callback function is called sequentially, and the return value of the callback function is used to
determine the return value of the <code>Array</code> method.</p>
<p>If the callback function does not return a value, the array method may not work as expected and is most likely a mistake.</p>
<p>This rule applies to the following methods of an array:</p>
<ul>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from"><code>Array.from</code></a> </li>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/every"><code>Array.prototype.every</code></a>
  </li>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter"><code>Array.prototype.filter</code></a>
  </li>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/find"><code>Array.prototype.find</code></a>
  </li>
  <li> <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/findLast"><code>Array.prototype.findLast</code></a>
  </li>
  <li> <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/findIndex"><code>Array.prototype.findIndex</code></a>
  </li>
  <li> <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/findLastIndex"><code>Array.prototype.findLastIndex</code></a> </li>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map"><code>Array.prototype.map</code></a> </li>
  <li> <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/flatMap"><code>Array.prototype.flatMap</code></a> </li>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduce"><code>Array.prototype.reduce</code></a>
  </li>
  <li> <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduceRight"><code>Array.prototype.reduceRight</code></a> </li>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/some"><code>Array.prototype.some</code></a>
  </li>
  <li> <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/sort"><code>Array.prototype.sort</code></a>
  </li>
  <li> <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/toSorted"><code>Array.prototype.toSorted</code></a>
  </li>
</ul>
<p>If there is no <code>return</code>, the callback will implicitly return <code>undefined</code>, which may cause unexpected behavior or errors in
the code.</p>

```js
let arr = ["a", "b", "c"];
let merged = arr.reduce(function(a, b) {
  a.concat(b); // Noncompliant: No return statement, will result in TypeError
});
```
<p>Always add a return statement to the callback function passed to the array method.</p>

```js
let arr = ["a", "b", "c"];
let merged = arr.reduce(function(a, b) {
  return a.concat(b);
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array">Array</a> </li>
</ul>