<h2>Why is this an issue?</h2>
<p>Destructuring is a convenient way of extracting multiple values from data stored in (possibly nested) objects and arrays. It can make code more
concise and expressive by directly extracting values or properties needed from arrays or objects. However, it is possible to define an empty pattern
that has no effect, where no variables are bound to the destructured values.</p>

```js
let {a: {}} = myObj; // Noncompliant: this does not create any variable
function foo({p: []}) { // Noncompliant: this does not define any parameter
  // ...
}
```
<p>When empty curly or square brackets are bound to a pattern with a colon (<code>:</code>), like <code>{ pattern: [] }</code> or <code>{ pattern: {}
}</code>, the intent is likely to define a default value. To properly define such a default value, use the assignment operator (<code>=</code>)
instead.</p>

```js
let {a = {}} = myObj;
function foo({p = []}) {
  // ...
}
```
<p>If that is not the intention, complete the destructuring pattern to contain the variables to create.</p>

```js
let {a: {b, c}} = myObj;
function foo({p: [a, b, c]}) {
  // ...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Destructuring_assignment">Destructuring
  assignment</a> </li>
</ul>