<h2>Why is this an issue?</h2>
<p>Storing a value inside a collection at a given key or index and then unconditionally overwriting it without reading the initial value is a case of
a "dead store".</p>
<p>This rule detects repeatedly adding an element at the same index or key in a collection or adding identical elements to a set.</p>

```js
fruits[1] = "banana";
fruits[1] = "apple";  // Noncompliant

myMap.set("key", 1);
myMap.set("key", 2); // Noncompliant

mySet.add(1);
mySet.add(1); // Noncompliant
```
<p>This practice is redundant and will cause confusion for the reader. More importantly, it is often an error and not what the developer intended to
do.</p>