<h2>Why is this an issue?</h2>
<p>In PHP, references allow you to create multiple names for the same variable, enabling you to access and manipulate its value through different
identifiers. They are denoted by the ampersand symbol &amp; placed before the variable name during declaration or assignment.</p>
<p>Any modification a method makes to a function parameter passed by reference will also be made to the original value.</p>
<p>This feature can be difficult to use correctly, particularly if the callee is not expecting a reference.</p>
<p>The improper use of references in function calls can make code less efficient rather than more efficient.</p>
<h3>What is the potential impact?</h3>
<p>While references can provide flexibility and efficiency in certain scenarios, they can also introduce complexity and potential pitfalls. Incorrect
usage of references may lead to unexpected behavior, difficult-to-debug code, and unintended side effects. It’s important to exercise caution and
fully understand the implications before employing references.</p>
<h2>How to fix it in Core PHP</h2>
<p>Refactor your code to not pass a reference as a function parameter.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
myfun(&$name);  // Noncompliant
```
<h4>Compliant solution</h4>

```php
myfun($name);
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/374">CWE-374 - Weakness Base Passing Mutable Objects to an Untrusted Method</a> </li>
</ul>