<h2>Why is this an issue?</h2>
<p>Because it is dynamically typed, PHP does not enforce a return type on a function. This means that different paths through a function can return
different types of values, which can be very confusing to the user and significantly harder to maintain.</p>
<p>In particular, it is consequently also possible to mix empty <code>return</code> statements (implicitly returning <code>null</code>) with some
returning an expression. This rule verifies that all the <code>return</code> statements from a function are consistent.</p>
<h3>Noncompliant code example</h3>

```php
function foo($a) { // Noncompliant, function will return "true" or null
  if ($a == 1) {
    return true;
  }
  return;
}
```
<h3>Compliant solution</h3>

```php
function foo($a) {
  if ($a == 1) {
    return true;
  }
  return false;
}
```
<p>or</p>

```php
function foo($a) {
  if ($a == 1) {
    return true;
  }
  return null;
}
```