<h2>Why is this an issue?</h2>
<p>In PHP it is not required to initialize variables before their usage. However, using uninitialized variables is considered bad practice and should
be avoided because of the following reasons:</p>
<ul>
  <li> The value and type of uninitialized variables depend on the context of their first usage. It is better to be explicit about those to avoid
  confusion. </li>
  <li> The interpreter raises a warning or a notice in many cases. </li>
</ul>
<h3>Noncompliant code example</h3>

```php
<?php

function getText(array $lines): string {
    foreach ($lines as $line) {
        $text .= $line;
    }

    return $text;
}
```
<h3>Compliant solution</h3>

```php
<?php

function getText(array $lines): string {
    $text = "";

    foreach ($lines as $line) {
        $text .= $line;
    }

    return $text;
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/457">CWE-457 - Use of Uninitialized Variable</a> </li>
</ul>