<h2>Why is this an issue?</h2>
<p>Calling a function or a method with fewer or more arguments than expected will raise a TypeError. This is usually a bug and should be fixed.</p>
<p>Provide missing arguments to the call, or define default values if there are fewer arguments.</p>
<p>Reduce the number of arguments provided by the function call, or add more parameter if there are more arguments than expected.</p>
<h3>Noncompliant code example</h3>

```php
function myFunction($a, $b, $c = null) {
  //...
}

myFunction($a); // Noncompliant - 2 arguments are required
```
<h3>Exceptions</h3>
<p>No issue is reported when arguments are used in the body of the function being called.</p>

```php
function myFunction() {
  $arg_list = func_get_args();
  //...
}

myFunction($a, $b);
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/628">CWE-628 - Function Call with Incorrectly Specified Arguments</a> </li>
</ul>