<h2>Why is this an issue?</h2>
<p>If a variable that is not supposed to change is not marked as <code>const</code>, it could be accidentally reassigned elsewhere in the code,
leading to unexpected behavior and bugs that can be hard to track down.</p>
<p>By declaring a variable as <code>const</code>, you ensure that its value remains constant throughout the code. It also signals to other developers
that this value is intended to remain constant. This can make the code easier to understand and maintain.</p>
<p>In some cases, using <code>const</code> can lead to performance improvements. The compiler might be able to make optimizations knowing that the
value of a <code>const</code> variable will not change.</p>
<h2>How to fix it</h2>
<p>Mark the given variable with the <code>const</code> modifier.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function seek(input) {
  let target = 32;  // Noncompliant
  for (const i of input) {
    if (i === target) {
      return true;
    }
  }
  return false;
}
```
<h4>Compliant solution</h4>

```ts
function seek(input) {
  const target = 32;
  for (const i of input) {
    if (i === target) {
      return true;
    }
  }
  return false;
}
```

```ts
function getUrl(protocol, domain, path) {    
  let url; // Noncompliant
  url = `${protocol}/${domain}/${path}`;
  return url;
}
```
<h4>Compliant solution</h4>

```ts
function getUrl(protocol, domain, path) {  
  const url = `${protocol}/${domain}/${path}`;
  return url;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/const">const</a> </li>
</ul>