<h2>Why is this an issue?</h2>
<p>An <code>async</code> function always wraps the return value in a <code>Promise</code>. Using <code>return await</code> is not required and comes
at an extra performance cost. However, you might wish to keep it as it preserves the function call in the stack trace in case an error is thrown
asynchronously.</p>
<h3>Noncompliant code example</h3>

```ts
async function foo() {
  // ...
}

async function bar() {
  // ...
  return await foo(); // Noncompliant
}
```
<h3>Compliant solution</h3>

```ts
async function foo() {
  // ...
}

async function bar() {
  // ...
  return foo();
}
```