<h2>Why is this an issue?</h2>
<p>The <code>\</code> (backslash) character indicates that the next character should be treated as a literal character rather than as a special
character or string delimiter. For instance, it is common to escape single quotes inside a string literal using the single quote delimiter like
<code>'It\'s a beautiful day'</code>. Escaping is only meaningful for special characters. Escaping non-special characters in strings, template
literals, and regular expressions doesn’t affect their value.</p>

```ts
const regex = /[\[]/;  // Noncompliant: '[' does not need to be escaped when inside a character class '[]'
const octal = '\8';    // Noncompliant: '8' is not valid octal number
const hello = 'Hello, world\!';    // Noncompliant: '!' is not a special character
const path  = `\/${some}\/${dir}`; // Noncompliant: '/' is not a special character
```
<p>Therefore, useless escapes impact code readability and could even denote a bug in the code if the developer left it by mistake or intended to
escape another special character instead.</p>
<p>You should check if the escape character was not misplaced. Useless character escapes can safely be removed without changing the original
value.</p>

```ts
const regex = /[[]/;
const octal = '8';
const hello = 'Hello, world!';
const path  = `/${some}/${dir}`;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_expressions#escaping">Escaping in Regular
  expressions</a> </li>
  <li> W3Schools - <a href="https://www.w3schools.com/js/js_strings.asp">JavaScript strings</a> </li>
</ul>