<h2>Why is this an issue?</h2>
<p>In React, the <code>ReactDOM.render()</code> method is used to render a React component into a DOM element. It has a return value, but it’s
generally recommended not to use it. The method might return a reference to the root <code>ReactComponent</code> instance, but it can be unpredictable
and may not always be useful. Indeed, the return value can vary depending on the version of React you’re using and the specific circumstances in which
it’s called.</p>

```ts
const instance = ReactDOM.render(<App />, document.body); // Noncompliant: using the return value of 'ReactDOM.render'
doSomething(instance);
```

```ts
ReactDOM.render(<App />, document.body);
```
<p>Alternatively, if you really need a reference to the root <code>ReactComponent</code> instance, the preferred solution is to attach a "callback
ref" to the root element.</p>

```ts
ReactDOM.render(<App />, document.body, callbackRef);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/reference/react-dom/render">ReactDom#render</a> </li>
  <li> React Documentation - <a href="https://react.dev/learn/referencing-values-with-refs#adding-a-ref-to-your-component">Adding a ref to your
  component</a> </li>
</ul>