<h2>Why is this an issue?</h2>
<p>ARIA (Accessible Rich Internet Applications) attributes are used to enhance the accessibility of web content and web applications. These attributes
provide additional information about an element’s role, state, properties, and values to assistive technologies like screen readers.</p>
<p>This rule checks that when using the <code>role</code> property in DOM elements, its value is a valid non-abstract ARIA role.</p>
<p>This rule does not cover non-DOM elements, such as custom components.</p>
<h2>How to fix it</h2>
<p>Check that each element with a defined ARIA role has a valid non-abstract value.</p>

```ts
<div role="meth" aria-label="a^{2} + b^{2} = c^{2}">
  a<sup>2</sup> + b<sup>2</sup> = c<sup>2</sup>
</div>
```
<p>To fix the code use a valid value for the ARIA role attribute.</p>

```ts
<div role="math" aria-label="a^{2} + b^{2} = c^{2}">
  a<sup>2</sup> + b<sup>2</sup> = c<sup>2</sup>
</div>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques">Using ARIA: Roles, states, and
  properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">ARIA roles (Reference)</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-1.2/">Accessible Rich Internet Applications (WAI-ARIA) 1.2</a> </li>
</ul>