# Blanket Disable Command

`swiftlint:disable` commands should use `next`, `this` or `previous` to disable rules for a single line, or `swiftlint:enable` to re-enable the rules immediately after the violations to be ignored, instead of disabling the rule for the rest of the file.

## Rationale

The intent of this rule is to prevent code like

```swift
// swiftlint:disable force_unwrapping
let foo = bar!
```

which disables the `force_unwrapping` rule for the remainder of the file, instead of just for the specific violation.

`next`, `this`, or `previous` can be used to restrict the disable command's scope to a single line, or it can be re-enabled after the violations.

To disable this rule in code you will need to do something like

```swift
// swiftlint:disable:next blanket_disable_command
// swiftlint:disable force_unwrapping
```

## Non Triggering Examples

```swift
// swiftlint:disable unused_import
// swiftlint:enable unused_import
```

```swift
// swiftlint:disable unused_import unused_declaration
// swiftlint:enable unused_import
// swiftlint:enable unused_declaration
```

```swift
// swiftlint:disable:this unused_import
```

```swift
// swiftlint:disable:next unused_import
```

```swift
// swiftlint:disable:previous unused_import
```

## Triggering Examples

```swift
// swiftlint:disable ↓unused_import
```

```swift
// swiftlint:disable unused_import ↓unused_declaration
// swiftlint:enable unused_import
```

```swift
// swiftlint:disable unused_import
// swiftlint:disable ↓unused_import
// swiftlint:enable unused_import
```

```swift
// swiftlint:enable ↓unused_import
```

```swift
// swiftlint:disable all
```