# Comment Spacing

Prefer at least one space after slashes for comments

## Non Triggering Examples

```swift
// This is a comment
```

```swift
/// Triple slash comment
```

```swift
// Multiline double-slash
// comment
```

```swift
/// Multiline triple-slash
/// comment
```

```swift
/// Multiline triple-slash
///   - This is indented
```

```swift
// - MARK: Mark comment
```

```swift
//: Swift Playground prose section
```

```swift
///////////////////////////////////////////////
// Comment with some lines of slashes boxing it
///////////////////////////////////////////////
```

```swift
//:#localized(key: "SwiftPlaygroundLocalizedProse")
```

```swift
/* Asterisk comment */
```

```swift
/*
    Multiline asterisk comment
*/
```

```swift
/*:
    Multiline Swift Playground prose section
*/
```

```swift
/*#-editable-code Swift Playground editable area*/default/*#-end-editable-code*/
```

## Triggering Examples

```swift
//↓Something
```

```swift
//↓MARK
```

```swift
//↓👨‍👨‍👦‍👦Something
```

```swift
func a() {
    //↓This needs refactoring
    print("Something")
}
//↓We should improve above function
```

```swift
///↓This is a comment
```

```swift
/// Multiline triple-slash
///↓This line is incorrect, though
```

```swift
//↓- MARK: Mark comment
```

```swift
//:↓Swift Playground prose section
```