# Discouraged Assert

Prefer `assertionFailure()` and/or `preconditionFailure()` over `assert(false)`

## Non Triggering Examples

```swift
assert(true)
```

```swift
assert(true, "foobar")
```

```swift
assert(true, "foobar", file: "toto", line: 42)
```

```swift
assert(false || true)
```

```swift
XCTAssert(false)
```

## Triggering Examples

```swift
↓assert(false)
```

```swift
↓assert(false, "foobar")
```

```swift
↓assert(false, "foobar", file: "toto", line: 42)
```

```swift
↓assert(   false    , "foobar")
```