# Duplicate Enum Cases

Enum shouldn't contain multiple cases with the same name

## Non Triggering Examples

```swift
enum PictureImport {
    case addImage(image: UIImage)
    case addData(data: Data)
}
```

```swift
enum A {
    case add(image: UIImage)
}
enum B {
    case add(image: UIImage)
}
```

```swift
enum Tag: String {
#if CONFIG_A
    case value = "CONFIG_A"
#elseif CONFIG_B
    case value = "CONFIG_B"
#else
    case value = "CONFIG_DEFAULT"
#endif
}
```

```swift
enum Target {
#if os(iOS)
  case file
#else
  case file(URL)
#endif
}
```

## Triggering Examples

```swift
enum PictureImport {
    case ↓add(image: UIImage)
    case addURL(url: URL)
    case ↓add(data: Data)
}
```