# Empty Collection Literal

Prefer checking `isEmpty` over comparing collection to an empty array or dictionary literal

## Non Triggering Examples

```swift
myArray = []
```

```swift
myArray.isEmpty
```

```swift
!myArray.isEmpty
```

```swift
myDict = [:]
```

## Triggering Examples

```swift
myArray↓ == []
```

```swift
myArray↓ != []
```

```swift
myArray↓ == [ ]
```

```swift
myDict↓ == [:]
```

```swift
myDict↓ != [:]
```

```swift
myDict↓ == [: ]
```

```swift
myDict↓ == [ :]
```

```swift
myDict↓ == [ : ]
```