# Empty Parameters

Prefer `() -> ` over `Void -> `

## Non Triggering Examples

```swift
let abc: () -> Void = {}
```

```swift
func foo(completion: () -> Void)
```

```swift
func foo(completion: () throws -> Void)
```

```swift
let foo: (ConfigurationTests) -> Void throws -> Void)
```

```swift
let foo: (ConfigurationTests) ->   Void throws -> Void)
```

```swift
let foo: (ConfigurationTests) ->Void throws -> Void)
```

## Triggering Examples

```swift
let abc: ↓(Void) -> Void = {}
```

```swift
func foo(completion: ↓(Void) -> Void)
```

```swift
func foo(completion: ↓(Void) throws -> Void)
```

```swift
let foo: ↓(Void) -> () throws -> Void)
```