# First Where

Prefer using `.first(where:)` over `.filter { }.first` in collections

## Non Triggering Examples

```swift
kinds.filter(excludingKinds.contains).isEmpty && kinds.first == .identifier
```

```swift
myList.first(where: { $0 % 2 == 0 })
```

```swift
match(pattern: pattern).filter { $0.first == .identifier }
```

```swift
(myList.filter { $0 == 1 }.suffix(2)).first
```

```swift
collection.filter("stringCol = '3'").first
```

```swift
realm?.objects(User.self).filter(NSPredicate(format: "email ==[c] %@", email)).first
```

```swift
if let pause = timeTracker.pauses.filter("beginDate < %@", beginDate).first { print(pause) }
```

## Triggering Examples

```swift
↓myList.filter { $0 % 2 == 0 }.first
```

```swift
↓myList.filter({ $0 % 2 == 0 }).first
```

```swift
↓myList.map { $0 + 1 }.filter({ $0 % 2 == 0 }).first
```

```swift
↓myList.map { $0 + 1 }.filter({ $0 % 2 == 0 }).first?.something()
```

```swift
↓myList.filter(someFunction).first
```

```swift
↓myList.filter({ $0 % 2 == 0 })
.first
```

```swift
(↓myList.filter { $0 == 1 }).first
```

```swift
↓myListOfDict.filter { dict in dict["1"] }.first
```

```swift
↓myListOfDict.filter { $0["someString"] }.first
```