# Flat Map over Map Reduce

Prefer `flatMap` over `map` followed by `reduce([], +)`

## Non Triggering Examples

```swift
let foo = bar.map { $0.count }.reduce(0, +)
```

```swift
let foo = bar.flatMap { $0.array }
```

## Triggering Examples

```swift
let foo = ↓bar.map { $0.array }.reduce([], +)
```