# Mark

MARK comment should be in valid format. e.g. '// MARK: ...' or '// MARK: - ...'

## Non Triggering Examples

```swift
// MARK: good
```

```swift
// MARK: - good
```

```swift
// MARK: -
```

```swift
// MARK: - 
```

```swift
// BOOKMARK
```

```swift
//BOOKMARK
```

```swift
// BOOKMARKS
```

```swift
// MARK: This is good.
```

```swift
// MARK: - This is good.
```

```swift
// MARK: --- This is good. ---
```

```swift
// MARK: – This is dash separator
```

```swift
// Mark text
```

```swift
//  MarkdownText.swift
```

```swift
// MARK: good
func foo() {
    let bar = 0
      // MARK: good
}
```

```swift
/*
func test1() {
}
//MARK: mark
func test2() {
}
*/
```

## Triggering Examples

```swift
↓//MARK: bad
```

```swift
↓// MARK:bad
```

```swift
↓//MARK:bad
```

```swift
↓//  MARK: bad
```

```swift
↓// MARK:  bad
```

```swift
↓// MARK: -bad
```

```swift
↓// MARK:- bad
```

```swift
↓// MARK:-bad
```

```swift
↓//MARK: - bad
```

```swift
↓//MARK:- bad
```

```swift
↓//MARK: -bad
```

```swift
↓//MARK:-bad
```

```swift
↓//Mark: bad
```

```swift
↓// Mark: bad
```

```swift
↓// MARK bad
```

```swift
↓//MARK bad
```

```swift
↓// MARK - bad
```

```swift
↓//MARK : bad
```

```swift
↓// MARKL:
```

```swift
↓// MARKR 
```

```swift
↓// MARKK -
```

```swift
↓/// MARK:
```

```swift
↓/// MARK bad
```

```swift
// MARK: good
func foo() {
    let bar = 0
      ↓//MARK: bad
}
```

```swift
↓//MARK:- Top-Level bad mark
↓//MARK:- Another bad mark
struct MarkTest {}
↓// MARK:- Bad mark
extension MarkTest {}
```