# Multiline Arguments

Arguments should be either on the same line, or one per line

## Non Triggering Examples

```swift
foo()
```

```swift
foo(
)
```

```swift
foo { }
```

```swift
foo {

}
```

```swift
foo(0)
```

```swift
foo(0, 1)
```

```swift
foo(0, 1) { }
```

```swift
foo(0, param1: 1)
```

```swift
foo(0, param1: 1) { }
```

```swift
foo(param1: 1)
```

```swift
foo(param1: 1) { }
```

```swift
foo(param1: 1, param2: true) { }
```

```swift
foo(param1: 1, param2: true, param3: [3]) { }
```

```swift
foo(param1: 1, param2: true, param3: [3]) {
    bar()
}
```

```swift
foo(param1: 1,
    param2: true,
    param3: [3])
```

```swift
foo(
    param1: 1, param2: true, param3: [3]
)
```

```swift
foo(
    param1: 1,
    param2: true,
    param3: [3]
)
```

```swift
Picker(selection: viewStore.binding(\.$someProperty)) {
   ForEach(SomeEnum.allCases, id: \.rawValue) { someCase in
      Text(someCase.rawValue)
         .tag(someCase)
   }
} label: {
   EmptyView()
}
```

```swift
UIView.animate(withDuration: 1,
               delay: 0) {
    // sample
    print("a")
} completion: { _ in
    // sample
    print("b")
}
```

```swift
UIView.animate(withDuration: 1, delay: 0) {
    print("a")
} completion: { _ in
    print("b")
}
```

```swift
f(
    foo: 1,
    bar: false,
)
```

## Triggering Examples

```swift
foo(0,
    param1: 1, ↓param2: true, ↓param3: [3])
```

```swift
foo(0, ↓param1: 1,
    param2: true, ↓param3: [3])
```

```swift
foo(0, ↓param1: 1, ↓param2: true,
    param3: [3])
```

```swift
foo(
    0, ↓param1: 1,
    param2: true, ↓param3: [3]
)
```