# Multiline Literal Brackets

Multiline literals should have their surrounding brackets in a new line

## Non Triggering Examples

```swift
let trio = ["harry", "ronald", "hermione"]
let houseCup = ["gryffindor": 460, "hufflepuff": 370, "ravenclaw": 410, "slytherin": 450]
```

```swift
let trio = [
    "harry",
    "ronald",
    "hermione"
]
let houseCup = [
    "gryffindor": 460,
    "hufflepuff": 370,
    "ravenclaw": 410,
    "slytherin": 450
]
```

```swift
let trio = [
    "harry", "ronald", "hermione"
]
let houseCup = [
    "gryffindor": 460, "hufflepuff": 370,
    "ravenclaw": 410, "slytherin": 450
]
```

```swift
_ = [
    1,
    2,
    3,
    4,
    5, 6,
    7, 8, 9
]
```

## Triggering Examples

```swift
let trio = [↓"harry",
            "ronald",
            "hermione"
]
```

```swift
let houseCup = [↓"gryffindor": 460, "hufflepuff": 370,
                "ravenclaw": 410, "slytherin": 450
]
```

```swift
let houseCup = [↓"gryffindor": 460,
                "hufflepuff": 370,
                "ravenclaw": 410,
                "slytherin": 450↓]
```

```swift
let trio = [
    "harry",
    "ronald",
    "hermione"↓]
```

```swift
let houseCup = [
    "gryffindor": 460, "hufflepuff": 370,
    "ravenclaw": 410, "slytherin": 450↓]
```

```swift
class Hogwarts {
    let houseCup = [
        "gryffindor": 460, "hufflepuff": 370,
        "ravenclaw": 410, "slytherin": 450↓]
}
```

```swift
_ = [
    1,
    2,
    3,
    4,
    5, 6,
    7, 8, 9↓]
```

```swift
_ = [↓1, 2, 3,
     4, 5, 6,
     7, 8, 9
]
```

```swift
class Hogwarts {
    let houseCup = [
        "gryffindor": 460, "hufflepuff": 370,
        "ravenclaw": 410, "slytherin": slytherinPoints.filter {
            $0.isValid
        }.sum()↓]
}
```