# No Space in Method Call

Don't add a space between the method name and the parentheses

## Non Triggering Examples

```swift
foo()
```

```swift
object.foo()
```

```swift
object.foo(1)
```

```swift
object.foo(value: 1)
```

```swift
object.foo { print($0 }
```

```swift
list.sorted { $0.0 < $1.0 }.map { $0.value }
```

```swift
self.init(rgb: (Int) (colorInt))
```

```swift
Button {
    print("Button tapped")
} label: {
    Text("Button")
}
```

## Triggering Examples

```swift
foo↓ ()
```

```swift
object.foo↓ ()
```

```swift
object.foo↓ (1)
```

```swift
object.foo↓ (value: 1)
```

```swift
object.foo↓ () {}
```

```swift
object.foo↓     ()
```

```swift
object.foo↓     (value: 1) { x in print(x) }
```