# NSNumber Init as Function Reference

Passing `NSNumber.init` or `NSDecimalNumber.init` as a function reference is dangerous as it can cause the wrong initializer to be used, causing crashes; use `.init(value:)` instead

## Non Triggering Examples

```swift
[0, 0.2].map(NSNumber.init(value:))
```

```swift
let value = NSNumber.init(value: 0.0)
```

```swift
[0, 0.2].map { NSNumber(value: $0) }
```

```swift
[0, 0.2].map(NSDecimalNumber.init(value:))
```

```swift
[0, 0.2].map { NSDecimalNumber(value: $0) }
```

## Triggering Examples

```swift
[0, 0.2].map(↓NSNumber.init)
```

```swift
[0, 0.2].map(↓NSDecimalNumber.init)
```